function []=deice_fdom_cal1(skt)
%function []=deice_fdom_cal1(skt)
% Version 1
% Ian Stothers May 2024


if(exist('skt')==0)
   skt.ip='192.168.1.4';
   ip=skt.ip;
else
  if (ischar(skt))
   ip=skt;
  else
   ip=skt.ip;
  endif
endif
if(exist('update_rate')==0)   update_rate=20; endif


  if (ischar(skt))
    skt=sktopen(skt);
  endif




STM32F103_bitfields; % Get some bitfields
setenv('XDG_SESSION_TYPE','x11');
udpset(skt,'HoldFreq',0);
  cfg_n=udpget(skt,'BuildTimeStamp');
  cfg_n=cfg_n(find(cfg_n~=' '));
  cfg_n=cfg_n(find(cfg_n~=':'));

AutoStart=udpget(skt,'AutoStart');
if (AutoStart<1)
  if (exist([cfg_n '.bin'])>0)
   printf(["Using existing config file " cfg_n ".bin   \n"]);
  else
   printf("\nSetting Up ADC\n");
   ADC_Scale = [248.34 0; 0 24];  % from Arlie
   udpset(skt,'ADC_Scale',ADC_Scale);

   udp_capture_start(skt, 'b') ;     %start the config capture
   SRate=STM32F103_ADC_SETUP(skt,[1;0],6750000/8); % make 1st channel volts 2nd current
   STM32F103_CC_SETUP_B3(skt);
   udpset(skt,'DoTheDFT',1);
   udpset(skt,'AutoStart',1);
   udpset(skt,'ADC_SR',SRate);
   udp_capture_stop;                 % stop the capture
   printf('Programming The Config\n');

   printf(['Saving new config file ' cfg_n '.bin   \n']);

   rename('ConfigLog.bin',[cfg_n '.bin']);    % put the cature file to somewher it won't get auto deleted
  endif
  printf(['Putting Autostart file on device  \n']);

  udp_put_startup(skt,[cfg_n '.bin']);
  printf("Resetting Device\n");
  udpreset(skt);
  pause(2);
  skt=sktopen(skt.ip);

endif
    SRate= udpget(skt,'ADC_SR');
    dodft=udpget(skt,'DoTheDFT');


%dftest_RES(skt);
%dftest_POW(skt);

  if (exist('butter')==0)
   pkg load signal;
  end
  BuildName=udpget(skt,"BuildName");
  BuildName=BuildName(find(BuildName>0));
  BuildTimeStamp=udpget(skt,"BuildTimeStamp");
  BuildTimeStamp=BuildTimeStamp(find(BuildTimeStamp>0));
  PartSerno=udpget(skt,'PartSerno');
  TextPartNo=udpget(skt,'TextPartNo');
  TextPartNo=TextPartNo(1:min(find(TextPartNo==0)-1));


%%Calibration Bits%%%
% Calibration initial match for rload only
  Vcal= 1; % Compensate for phase angle into voltage input vs current with resistive load
  Ical= 1;      % Note the 1 in Vcal and Ical can be used to change non frequency sensitive gain issues - or use ADC_Scale
  ADC_Scale = [248.34 0; 0 24];  % from Arlie
  Radc=1000;   % For calcullation of atten
  Cadc=11e-12; % For calcullation of atten
%% end of calibration bits


  if (size(findname(skt.name,"ADC_Scale"))>0)
   ADC_Scale=udpget(skt,'ADC_Scale');
  endif
  if (size(findname(skt.name,"Vcal"))>0)
   Vcal=udpget(skt,'Vcal')*[1 ; i];
  endif
  if (size(findname(skt.name,"Ical"))>0)
   Ical=udpget(skt,'Ical')*[1 ; i];
  endif
  if (size(findname(skt.name,"ADC_RC"))>0)
   ADC_RC=udpget(skt,'ADC_RC');
  else
   ADC_RC=Radc*Cadc;
  endif
%tfoc=exp(i*pi*113/180)/365;  % open circuit output impedance - measured by setting lod open and tfoc=0;
  if (size(findname(skt.name,"tfoc"))>0)
   tfocs=udpget(skt,'tfoc');
   tfoc=tfocs(1)+i*tfocs(2);
  else
   tfoc=0;
  endif
  if (size(findname(skt.name,"tfsc"))>0)
   tfscs=udpget(skt,'tfsc');
   tfsc=tfscs(1)+i*tfscs(2);
  else
   tfsc=0;
  endif

  setenv('XDG_SESSION_TYPE','x11');
  if (size(findname(skt.name,"ADC_SR"))>0)
   udpset(skt,'ADC_SR',SRate);
  endif






  Results=udpget(skt,'Results');
  Sxy=Results(1)+i*Results(2);
  Syy=Results(3);
  Sxx=Results(4);
  Fest=Results(5);
  Fest_Max=Results(6);
  Fest_Long=Results(7);

  RawResults=udpget(skt,'RawResults');
  RawSxy=RawResults(1)+i*RawResults(2);
  RawSyy=RawResults(3);
  RawSxx=RawResults(4);


  res=[sprintf("Freqency=%2.4f MHz",Fest_Long/1e6)
    sprintf("Impedance=%4.3f Ohms  %4.1f Degrees",abs(Sxy/Syy),(180/pi)*angle(Sxy/Syy))
    sprintf("Power    Real=%4.3f  Imag=%4.3f  W",real(Sxy),imag(Sxy))
    sprintf("Voltage = %4.3f Vrms",sqrt(Sxx))
    sprintf("Current = %4.3f Irms",sqrt(Syy))
    sprintf("Serial  No.:%d Part No.:%s  ",PartSerno,TextPartNo)
    sprintf("BuildName:%s",BuildName)
    sprintf("BuildTimeStamp:%s",BuildTimeStamp)];
    data=ones(1,100)*sqrt(Sxx);
 f1=figure(1);
     clf
     subplot(1,2,2);
     set(f1,"numbertitle","off");
     set(f1,'name',['deice_fdom_cal1.m - ' skt.ip]);
     f1p=plot(data');
     f1tit=title(res);
     grid on;
     f1c=get(f1,'children');
     %axis([0 nbins/SRate -150 150]);
     %f1cc=get(f1c,'children');
     %legend(['Volts']);

     LoadRes=50;

    % xlabel(['Seconds      ' sprintf('Sample Rate = %6.1f',SRate)]   );
     ylabel('Volts');
     pb1=stopbut(f1,[15  45 100 22],"Set tfsc");
     pb2=stopbut(f1,[15  15 100 22],"Set tfoc");
     pb3=stopbut(f1,[15  330 100 22],"Save Config");
     pb4=stopbut(f1,[15  75 100 22],"Zero Ph");
     pb5=stopbut(f1,[15  135 100 22],"Set Vrms");
     pb6=stopbut(f1,[15  165 100 22],"Set Irms");
     pb7=stopbut(f1,[15  225 100 22],"Set Res Re");
     pb8=stopbut(f1,[15  195 100 22],"Set Res Im");
     pb9=stopbut(f1,[15  255 100 22],"Set TPart No.");
     pb10=stopbut(f1,[15  285 100 22],"Set Serial No.");
     pb11=stopbut(f1,[15  105 100 22],"Freq Track");

     eb5=editbox(f1,[140  135 100 22],   sprintf("%4.3f",sqrt(abs(Sxx))));
     eb6=editbox(f1,[140  165 100 22],   sprintf("%4.3f",sqrt(abs(Syy))));
     eb7=editbox(f1,[140  225 100 22],   sprintf("%4.3f",real(LoadRes)));
     eb8=editbox(f1,[140  195 100 22],   sprintf("%4.3f",imag(LoadRes)));
     eb9=editbox(f1,[140  255 100 22],   sprintf("%23s",TextPartNo));
     eb10=editbox(f1,[140  285 100 22],   sprintf("%4u",PartSerno));



  %try
  while (1)

  Results=udpget(skt,'Results');
  Sxy=Results(1)+i*Results(2);
  Syy=Results(3);
  Sxx=Results(4);
  Fest=Results(5);
  Fest_Max=Results(6);
  Fest_Long=Results(7);

  RawResults=udpget(skt,'RawResults');
  RawSxy=RawResults(1)+i*RawResults(2);
  RawSyy=RawResults(3);
  RawSxx=RawResults(4);


  res=[sprintf("Freqency=%2.4f MHz",Fest_Long/1e6)
    sprintf("Impedance=%4.3f Ohms  %4.1f Degrees",abs(Sxy/Syy),(180/pi)*angle(Sxy/Syy))
    sprintf("Power    Real=%4.3f  Imag=%4.3f  W",real(Sxy),imag(Sxy))
    sprintf("Voltage = %4.3f Vrms",sqrt(Sxx))
    sprintf("Current = %4.3f Irms",sqrt(Syy))
    sprintf("Serial  No.:%d Part No.:%s  ",PartSerno,TextPartNo)
    sprintf("BuildName:%s",BuildName)
    sprintf("BuildTimeStamp:%s",BuildTimeStamp)];
  set(f1tit,'string',res);
    data =[sqrt(Sxx) data( 1:(end-1))];
  set(f1p,'ydata',data)

     if(get(pb1,"value")==1)
      tfsc=(RawSxy/RawSyy);
      set(pb1,"value",0);
      udpset(skt,'tfsc',[real(tfsc) imag(tfsc)]);

     endif

     if(get(pb2,"value")==1)
      tfoc=1/(RawSxy/RawSyy);
      udpset(skt,'HoldFreq',1);
      set(pb11,"string","Freq Held");
      set(pb2,"value",0);
       udpset(skt,'tfoc',[real(tfoc) imag(tfoc)]);
     endif

     if(get(pb3,"value")==1)
      udpset(skt,'tfoc',[real(tfoc) imag(tfoc)]);
      udpset(skt,'tfsc',[real(tfsc) imag(tfsc)]);
      udpset(skt,'Vcal',[real(Vcal) imag(Vcal)]);
      udpset(skt,'ADC_Scale',ADC_Scale);
      udpset(skt,'PartSerno',PartSerno);
      udpset(skt,'TextPartNo',TextPartNo);
      udpprogconfig(skt);
      set(pb3,"value",0);
     endif

    if(get(pb4,"value")==1)
      set(pb4,"value",0);
      erang=(180/pi)*angle(Sxy);
      Vcal=Vcal*exp(-i*erang*pi/180);
      udpset(skt,'Vcal',[real(Vcal) imag(Vcal)]);
      udpset(skt,'HoldFreq',0);
      set(pb11,"string","Freq Track");
     endif


    if(get(pb5,"value")==1)
     st=get(eb5,"string");
     val5=sscanf(st,'%f');
     set(eb5,"string",sprintf('%4.3f',val5));
     set(pb5,"value",0);
     ADC_Scale(1,1)=    ADC_Scale(1,1)*val5/sqrt(Sxx);
     if (abs(LoadRes)>0)
      set(eb6,"string",sprintf('%4.3f',abs(val5/LoadRes)));
      ADC_Scale(2,2)=    ADC_Scale(2,2)*(val5/LoadRes)/sqrt(Syy);
     endif
     udpset(skt,'ADC_Scale',ADC_Scale);
    endif

    if(get(pb6,"value")==1)
     st=get(eb6,"string");
     val6=sscanf(st,'%f');
     set(eb6,"string",sprintf('%4.3f',val6));
       set(pb6,"value",0);
     ADC_Scale(2,2)=    ADC_Scale(2,2)*(val6/sqrt(Sxx));
     if (abs(LoadRes)>0)
      set(eb5,"string",sprintf('%4.3f',abs(val6*LoadRes)));
      ADC_Scale(1,1)=    ADC_Scale(1,1)*LoadRes*val6/sqrt(Syy);
     endif
     udpset(skt,'ADC_Scale',ADC_Scale);
    endif


   if(get(pb7,"value")==1)
     st=get(eb7,"string");
     val7=sscanf(st,'%f');
     set(eb7,"string",sprintf('%4.3f',val7));
     set(pb7,"value",0);
     LoadRes = val7+ imag(LoadRes);
   endif

   if(get(pb8,"value")==1)
     st=get(eb8,"string");
     val8=sscanf(st,'%f');
     set(eb8,"string",sprintf('%4.3f',val8));
     set(pb8,"value",0);
     LoadRes = i*val8+ real(LoadRes);
   endif

   if(get(pb9,"value")==1)
     st=get(eb9,"string");
     set(eb9,"string",st);
     set(pb9,"value",0);
     TextPartNo = st;
   endif

   if(get(pb10,"value")==1)
     st=get(eb10,"string");
     val10=sscanf(st,'%u');
     set(eb10,"string",sprintf('%u',val10));
     set(pb10,"value",0);
     PartSerno = val10;
   endif

   if(get(pb11,"value")==1)
     st=get(pb11,"string");
     if(strcmp(st,"Freq Track"))
      set(pb11,"string","Freq Held");
      udpset(skt,'HoldFreq',1);
     else
      set(pb11,"string","Freq Track");
            udpset(skt,'HoldFreq',0);
     endif
          set(pb11,"value",0);
   endif


   pause(0.05)
  endwhile
 % catch
  %cleanup
   if(isfigure(f1)==1) delete(f1); end
%   if(isfigure(f2)==1) delete(f2); end
   return;
 % end
endfunction



function [pb]=stopbut(f,pos,txt)
% Create an pushbutton control
 pb=uicontrol(...
 f,"style","togglebutton",...
 "string",txt,...
 "position",pos);
endfunction

function [eb]=editbox(f,pos,txt)
% Create an edit control
 eb = uicontrol (...
 f, "style", "edit",...
 "string", txt, ...
 "position",pos);
endfunction

function [eb]=textbox(f,pos,txt)
% Create an text box
 eb = uicontrol (...
 f, "style", "edit",...
 "string", txt, ...
 "position",pos);
endfunction
